﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Workflow.Runtime;
using System.Workflow.Runtime.Hosting;
using System.Workflow.Activities;

namespace HospitalStateWorkflow
{
    class Program
    {
        static void Main(string[] args)
        {
            using(WorkflowRuntime workflowRuntime = new WorkflowRuntime())
            {
                AutoResetEvent waitHandle = new AutoResetEvent(false);
                workflowRuntime.WorkflowCompleted += delegate(object sender, WorkflowCompletedEventArgs e) {waitHandle.Set();};
                workflowRuntime.WorkflowTerminated += delegate(object sender, WorkflowTerminatedEventArgs e)
                {
                    Console.WriteLine(e.Exception.Message);
                    waitHandle.Set();
                };

                var extDatEx = new ExternalDataExchangeService();
                workflowRuntime.AddService(extDatEx);

                var apptMgr = new AppointmentManager();
                extDatEx.AddService(apptMgr);

                WorkflowInstance instance = workflowRuntime.CreateWorkflow(typeof(HospitalStateWorkflow.Workflow1));
                instance.Start();

                var name = "Jan";

                apptMgr.DoPaperwork(instance.InstanceId, name);
                apptMgr.Wait(instance.InstanceId, name);
                apptMgr.SeeDoctor(instance.InstanceId, name);
                apptMgr.GoHome(instance.InstanceId, name);

                waitHandle.WaitOne();
                Console.ReadKey();
            }
        }
    }
}
